/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.ILivestock;
import net.dries007.tfc.api.util.IRidable;
import net.dries007.tfc.network.PacketSimpleMessage;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.advancements.TFCTriggers;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.entity.EntitiesTFC;
import net.dries007.tfc.objects.entity.animal.AnimalGroupingRules;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.objects.entity.animal.EntityDonkeyTFC;
import net.dries007.tfc.objects.entity.animal.EntityMuleTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EntityHorseTFC
extends EntityHorse
implements IAnimalTFC,
ILivestock,
IRidable {
    private static final DataParameter<Boolean> GENDER = EntityDataManager.func_187226_a(EntityHorseTFC.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BIRTHDAY = EntityDataManager.func_187226_a(EntityHorseTFC.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> FAMILIARITY = EntityDataManager.func_187226_a(EntityHorseTFC.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> FERTILIZED = EntityDataManager.func_187226_a(EntityHorseTFC.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HALTER = EntityDataManager.func_187226_a(EntityHorseTFC.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Long> PREGNANT_TIME = EntityDataManager.func_187226_a(EntityHorseTFC.class, EntitiesTFC.getLongDataSerializer());
    private long lastFed;
    private long lastFDecay;
    private long matingTime;
    private long lastDeath;
    private boolean birthMule;
    private float geneJump;
    private float geneHealth;
    private float geneSpeed;
    private int geneHorseVariant;

    public EntityHorseTFC(World world) {
        this(world, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityAnimalTFC.getRandomGrowth(ConfigTFC.Animals.HORSE.adulthood, ConfigTFC.Animals.HORSE.elder));
    }

    public EntityHorseTFC(World world, IAnimalTFC.Gender gender, int birthDay) {
        super(world);
        this.setGender(gender);
        this.setBirthDay(birthDay);
        this.setFamiliarity(0.0f);
        this.func_70873_a(0);
        this.matingTime = CalendarTFC.PLAYER_TIME.getTicks();
        this.lastDeath = CalendarTFC.PLAYER_TIME.getTotalDays();
        this.lastFDecay = CalendarTFC.PLAYER_TIME.getTotalDays();
        this.setFertilized(false);
        this.birthMule = false;
        this.geneHealth = 0.0f;
        this.geneJump = 0.0f;
        this.geneSpeed = 0.0f;
        this.geneHorseVariant = 0;
    }

    @Override
    public IAnimalTFC.Gender getGender() {
        return IAnimalTFC.Gender.valueOf((Boolean)this.field_70180_af.func_187225_a(GENDER));
    }

    @Override
    public void setGender(IAnimalTFC.Gender gender) {
        this.field_70180_af.func_187227_b(GENDER, (Object)gender.toBool());
    }

    @Override
    public int getBirthDay() {
        return (Integer)this.field_70180_af.func_187225_a(BIRTHDAY);
    }

    @Override
    public void setBirthDay(int value) {
        this.field_70180_af.func_187227_b(BIRTHDAY, (Object)value);
    }

    @Override
    public float getAdultFamiliarityCap() {
        return 0.35f;
    }

    @Override
    public float getFamiliarity() {
        return ((Float)this.field_70180_af.func_187225_a(FAMILIARITY)).floatValue();
    }

    @Override
    public void setFamiliarity(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        }
        if (value > 1.0f) {
            value = 1.0f;
        }
        this.field_70180_af.func_187227_b(FAMILIARITY, (Object)Float.valueOf(value));
    }

    @Override
    public boolean isFertilized() {
        return (Boolean)this.field_70180_af.func_187225_a(FERTILIZED);
    }

    @Override
    public void setFertilized(boolean value) {
        this.field_70180_af.func_187227_b(FERTILIZED, (Object)value);
    }

    @Override
    public void onFertilized(@Nonnull IAnimalTFC male) {
        this.setPregnantTime(CalendarTFC.PLAYER_TIME.getTotalDays());
        if (male.getClass() != this.getClass()) {
            this.birthMule = true;
        } else {
            int selection = this.field_70146_Z.nextInt(9);
            int i = selection < 4 ? this.func_110202_bQ() : (selection < 8 ? ((EntityHorse)male).func_110202_bQ() : this.field_70146_Z.nextInt(7));
            this.geneHorseVariant = i;
        }
        EntityAnimal father = (EntityAnimal)male;
        this.geneHealth = (float)((father.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + (double)this.func_110267_cL()) / 3.0);
        this.geneSpeed = (float)((father.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + this.func_110203_cN()) / 3.0);
        this.geneJump = (float)((father.func_110148_a(field_110271_bv).func_111125_b() + this.func_110148_a(field_110271_bv).func_111125_b() + this.func_110245_cM()) / 3.0);
    }

    @Override
    public int getDaysToAdulthood() {
        return ConfigTFC.Animals.HORSE.adulthood;
    }

    @Override
    public int getDaysToElderly() {
        return ConfigTFC.Animals.HORSE.elder;
    }

    @Override
    public boolean isReadyToMate() {
        if (this.getAge() != IAnimalTFC.Age.ADULT || this.getFamiliarity() < 0.3f || this.isFertilized() || this.isHungry()) {
            return false;
        }
        return this.matingTime + 2000L <= CalendarTFC.PLAYER_TIME.getTicks();
    }

    @Override
    public boolean isHungry() {
        return this.lastFed < CalendarTFC.PLAYER_TIME.getTotalDays();
    }

    @Override
    public IAnimalTFC.Type getType() {
        return IAnimalTFC.Type.MAMMAL;
    }

    @Override
    public TextComponentTranslation getAnimalName() {
        String entityString = EntityList.func_75621_b((Entity)this);
        return new TextComponentTranslation("tfc.animal." + entityString + "." + this.getGender().name().toLowerCase(), new Object[0]);
    }

    @Override
    public boolean isHalter() {
        return (Boolean)this.field_70180_af.func_187225_a(HALTER);
    }

    @Override
    public void setHalter(boolean value) {
        this.field_70180_af.func_187227_b(HALTER, (Object)value);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ()) && BlocksTFC.isGround(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    public void func_70873_a(int age) {
        super.func_70873_a(0);
    }

    public boolean func_70631_g_() {
        return this.getAge() == IAnimalTFC.Age.CHILD;
    }

    @Nonnull
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.getAnimalName().func_150254_d();
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!(BiomesTFC.isOceanicBiome(biome) || BiomesTFC.isBeachBiome(biome) || biomeType != BiomeHelper.BiomeType.TEMPERATE_FOREST && biomeType != BiomeHelper.BiomeType.PLAINS)) {
            return ConfigTFC.Animals.HORSE.rarity;
        }
        return 0;
    }

    @Override
    public BiConsumer<List<EntityLiving>, Random> getGroupingRules() {
        return AnimalGroupingRules.ELDER_AND_POPULATION;
    }

    @Override
    public int getMinGroupSize() {
        return 2;
    }

    @Override
    public int getMaxGroupSize() {
        return 5;
    }

    public long getPregnantTime() {
        return (Long)this.field_70180_af.func_187225_a(PREGNANT_TIME);
    }

    public void setPregnantTime(long pregnantTime) {
        this.field_70180_af.func_187227_b(PREGNANT_TIME, (Object)pregnantTime);
    }

    public long gestationDays() {
        return ConfigTFC.Animals.HORSE.gestation;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(GENDER, (Object)true);
        this.func_184212_Q().func_187214_a(BIRTHDAY, (Object)0);
        this.func_184212_Q().func_187214_a(FAMILIARITY, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(FERTILIZED, (Object)false);
        this.func_184212_Q().func_187214_a(PREGNANT_TIME, (Object)-1L);
        this.func_184212_Q().func_187214_a(HALTER, (Object)false);
    }

    public void func_70014_b(@Nonnull NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("gender", this.getGender().toBool());
        nbt.func_74768_a("birth", this.getBirthDay());
        nbt.func_74772_a("fed", this.lastFed);
        nbt.func_74772_a("decay", this.lastFDecay);
        nbt.func_74757_a("fertilized", this.isFertilized());
        nbt.func_74772_a("mating", this.matingTime);
        nbt.func_74776_a("familiarity", this.getFamiliarity());
        nbt.func_74772_a("lastDeath", this.lastDeath);
        nbt.func_74772_a("pregnant", this.getPregnantTime());
        nbt.func_74757_a("birthMule", this.birthMule);
        nbt.func_74776_a("geneSpeed", this.geneSpeed);
        nbt.func_74776_a("geneJump", this.geneJump);
        nbt.func_74776_a("geneHealth", this.geneHealth);
        nbt.func_74768_a("geneHorseVariant", this.geneHorseVariant);
        nbt.func_74757_a("halter", this.isHalter());
    }

    public void func_70037_a(@Nonnull NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setGender(IAnimalTFC.Gender.valueOf(nbt.func_74767_n("gender")));
        this.setBirthDay(nbt.func_74762_e("birth"));
        this.lastFed = nbt.func_74763_f("fed");
        this.lastFDecay = nbt.func_74763_f("decay");
        this.matingTime = nbt.func_74763_f("mating");
        this.setFertilized(nbt.func_74767_n("fertilized"));
        this.setFamiliarity(nbt.func_74760_g("familiarity"));
        this.lastDeath = nbt.func_74763_f("lastDeath");
        this.setPregnantTime(nbt.func_74763_f("pregnant"));
        this.birthMule = nbt.func_74767_n("birthMule");
        this.geneSpeed = nbt.func_74760_g("geneSpeed");
        this.geneJump = nbt.func_74760_g("geneJump");
        this.geneHealth = nbt.func_74760_g("geneHealth");
        this.geneHorseVariant = nbt.func_74762_e("geneHorseVariant");
        this.setHalter(nbt.func_74767_n("halter"));
    }

    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_HORSE;
    }

    public boolean func_184645_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() == Items.field_151063_bx) {
                return super.func_184645_a(player, hand);
            }
            if (this.canAcceptHalter(stack)) {
                return this.attemptApplyHalter((EntityAnimal)this, this.field_70170_p, player, stack);
            }
            if (this.isFood(stack) && player.func_70093_af() && this.getAdultFamiliarityCap() > 0.0f) {
                if (this.isHungry()) {
                    IFood cap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
                    if (cap != null && cap.isRotten()) {
                        return false;
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_98054_a(this.func_70631_g_());
                        this.lastFDecay = this.lastFed = CalendarTFC.PLAYER_TIME.getTotalDays();
                        this.func_175505_a(player, stack);
                        if (this.getAge() == IAnimalTFC.Age.CHILD || this.getFamiliarity() < this.getAdultFamiliarityCap()) {
                            float familiarity = this.getFamiliarity() + 0.06f;
                            if (this.getAge() != IAnimalTFC.Age.CHILD) {
                                familiarity = Math.min(familiarity, this.getAdultFamiliarityCap());
                            }
                            this.setFamiliarity(familiarity);
                        }
                        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187739_dZ, SoundCategory.AMBIENT, 1.0f, 1.0f);
                        TFCTriggers.FAMILIARIZATION_TRIGGER.trigger((EntityPlayerMP)player, this);
                    }
                    return true;
                }
                if (!this.field_70170_p.field_72995_K && this.isFertilized() && this.getType() == IAnimalTFC.Type.MAMMAL) {
                    TerraFirmaCraft.getNetwork().sendTo((IMessage)PacketSimpleMessage.translateMessage(PacketSimpleMessage.MessageCategory.ANIMAL, "tfc.tooltip.animal.mating.pregnant", this.getAnimalName()), (EntityPlayerMP)player);
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal instanceof EntityHorseTFC || otherAnimal instanceof EntityDonkeyTFC) {
            IAnimalTFC other = (IAnimalTFC)otherAnimal;
            return this.getGender() != other.getGender() && this.func_70880_s() && otherAnimal.func_70880_s();
        }
        return false;
    }

    @Nullable
    public EntityAgeable func_90011_a(@Nonnull EntityAgeable other) {
        if (other != this && this.getGender() == IAnimalTFC.Gender.FEMALE && other instanceof IAnimalTFC) {
            this.setFertilized(true);
            this.func_70875_t();
            this.onFertilized((IAnimalTFC)other);
        } else if (other == this) {
            EntityHorseTFC baby = new EntityHorseTFC(this.field_70170_p, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), (int)CalendarTFC.PLAYER_TIME.getTotalDays());
            this.func_190681_a((EntityAgeable)this, (AbstractHorse)baby);
            baby.func_110235_q(this.func_110202_bQ());
            return baby;
        }
        return null;
    }

    protected void func_184651_r() {
        EntityAnimalTFC.addCommonLivestockAI(this, 1.2);
        EntityAnimalTFC.addCommonPreyAI((EntityAnimal)this, 1.2);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0, EntityDonkeyTFC.class));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRunAroundLikeCrazy((AbstractHorse)this, 1.2));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
    }

    public void func_98054_a(boolean child) {
        double ageScale = 1.0 / (2.0 - this.getPercentToAdulthood());
        this.func_98055_j((float)ageScale);
    }

    protected boolean func_190678_b(EntityPlayer player, ItemStack stack) {
        return false;
    }

    protected void func_110237_h(EntityPlayer player) {
        if (this.isHalter()) {
            super.func_110237_h(player);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 100 == 0) {
            this.func_98054_a(false);
        }
        if (!this.field_70170_p.field_72995_K) {
            float familiarity;
            if (this.isFertilized() && CalendarTFC.PLAYER_TIME.getTotalDays() >= this.getPregnantTime() + this.gestationDays()) {
                this.birthChildren();
                this.setFertilized(false);
            }
            if (this.lastFDecay > -1L && this.lastFDecay + 1L < CalendarTFC.PLAYER_TIME.getTotalDays() && (familiarity = this.getFamiliarity()) < 0.3f) {
                familiarity = (float)((double)familiarity - 0.02 * (double)(CalendarTFC.PLAYER_TIME.getTotalDays() - this.lastFDecay));
                this.lastFDecay = CalendarTFC.PLAYER_TIME.getTotalDays();
                this.setFamiliarity(familiarity);
            }
            if (this.getGender() == IAnimalTFC.Gender.MALE && this.isReadyToMate()) {
                this.matingTime = CalendarTFC.PLAYER_TIME.getTicks();
                if (this.findFemaleMate()) {
                    this.func_146082_f(null);
                }
            }
            if (this.getAge() == IAnimalTFC.Age.OLD && this.lastDeath < CalendarTFC.PLAYER_TIME.getTotalDays()) {
                this.lastDeath = CalendarTFC.PLAYER_TIME.getTotalDays();
                Random random = new Random(this.field_96093_i.getMostSignificantBits() * CalendarTFC.PLAYER_TIME.getTotalDays());
                if (random.nextDouble() < ConfigTFC.Animals.HORSE.oldDeathChance) {
                    this.func_70106_y();
                }
            }
            if (this.getDaysToElderly() > 0 && this.getFamiliarity() < 0.1f && (float)(this.getDaysToElderly() + this.getDaysToAdulthood()) * 1.25f <= (float)(CalendarTFC.PLAYER_TIME.getTotalDays() - (long)this.getBirthDay())) {
                this.func_70106_y();
            }
        }
    }

    private boolean findFemaleMate() {
        List list = this.field_70170_p.func_72872_a(AbstractHorse.class, this.func_174813_aQ().func_186662_g(8.0));
        for (AbstractHorse ent : list) {
            IAnimalTFC animal;
            if (!(ent instanceof EntityHorseTFC) && !(ent instanceof EntityDonkeyTFC) || (animal = (IAnimalTFC)ent).getGender() != IAnimalTFC.Gender.FEMALE || !animal.isReadyToMate() || ent.func_70880_s()) continue;
            ent.func_146082_f(null);
            return true;
        }
        return false;
    }

    private void birthChildren() {
        int numberOfChildren = ConfigTFC.Animals.HORSE.babies;
        for (int i = 0; i < numberOfChildren; ++i) {
            IRidable baby;
            if (this.birthMule) {
                baby = new EntityMuleTFC(this.field_70170_p);
            } else {
                baby = new EntityHorseTFC(this.field_70170_p);
                ((EntityHorseTFC)baby).func_110235_q(this.geneHorseVariant);
            }
            baby.setBirthDay((int)CalendarTFC.PLAYER_TIME.getTotalDays());
            baby.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
            EntityAnimal animal = (EntityAnimal)baby;
            animal.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            if (this.geneHealth > 0.0f) {
                animal.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.geneHealth);
            }
            if (this.geneSpeed > 0.0f) {
                animal.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.geneSpeed);
            }
            if (this.geneJump > 0.0f) {
                animal.func_110148_a(field_110271_bv).func_111128_a((double)this.geneJump);
            }
            this.field_70170_p.func_72838_d((Entity)animal);
        }
        this.geneJump = 0.0f;
        this.geneSpeed = 0.0f;
        this.geneJump = 0.0f;
        this.birthMule = false;
    }
}

